/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.crafttweaker.nss;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.gson.JsonParseException;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.json.NSSSerializer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/ProjectE/NSSResolver")
@ZenCodeType.Name(value="mods.projecte.NSSResolver")
public class CrTNSSResolver {
    private CrTNSSResolver() {
    }

    @ZenCodeType.Method
    public static NormalizedSimpleStack deserialize(String representation) {
        try {
            return NSSSerializer.INSTANCE.deserialize(representation);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("Error deserializing NSS string representation", e);
        }
    }

    @ZenCodeType.Method
    public static NormalizedSimpleStack fromItem(Item item) {
        if (item == Items.f_41852_) {
            throw new IllegalArgumentException("Cannot make an NSS Representation from the empty item.");
        }
        return NSSItem.createItem((ItemLike)item);
    }

    @ZenCodeType.Method
    public static NormalizedSimpleStack fromItem(IItemStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Cannot make an NSS Representation from an empty item stack.");
        }
        return NSSItem.createItem(stack.getInternal());
    }

    @ZenCodeType.Method
    public static NormalizedSimpleStack fromFluid(IFluidStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Cannot make an NSS Representation from an empty fluid stack.");
        }
        return NSSFluid.createFluid(stack.getInternal());
    }

    @ZenCodeType.Method
    public static NormalizedSimpleStack fromFluid(Fluid fluid) {
        if (fluid == Fluids.f_76191_) {
            throw new IllegalArgumentException("Cannot make an NSS Representation from the empty fluid.");
        }
        return NSSFluid.createFluid(fluid);
    }
}

